#include "DebugLogger.h"

#pragma region Constructor

CDebugLogger::CDebugLogger()
{
  m_bIndentWritten = false;
  m_nIndent = -1;
  IndentChar = '\t';
}

#pragma endregion

#pragma region Destructor

CDebugLogger::~CDebugLogger(void)
{
  StopDebugLogging();
}

#pragma endregion

#pragma region Public Methods

void CDebugLogger::StartDebugLogging( char* strFileName_p )
{
  m_bIndentWritten = false;
  m_nIndent = -1;
  m_logFile.open( strFileName_p, ios_base::out | ios_base::app );
  if( m_logFile.is_open() )
    m_logFile << "Start of Log ******************************************************************"<< endl;
}

void CDebugLogger::StopDebugLogging()
{
  if( m_logFile.is_open() )
  {
    m_logFile << "End of Log ********************************************************************"<< endl;
    m_logFile.close();
  }
}

#pragma endregion

#pragma region Private Methods

void CDebugLogger::WriteDecUInt( unsigned int uVal_p )
{
  if( m_logFile.is_open() )
  {
    WriteIndentChars();
    m_logFile << dec << uVal_p;
  }
}

void CDebugLogger::WriteHexUInt( unsigned int uVal_p )
{
  if( m_logFile.is_open() )
  {
    WriteIndentChars();
    m_logFile << hex << uppercase << "0x" << uVal_p;
  }
}

void CDebugLogger::Write( const char* strMessage_p )
{
  if( m_logFile.is_open() )
  {
    WriteIndentChars();
    m_logFile << strMessage_p;
  }
}

void CDebugLogger::WriteLine( const char* strMessage_p )
{
  if( m_logFile.is_open() )
  {
    WriteIndentChars();
    m_logFile << strMessage_p << endl;
  }
}

void CDebugLogger::WriteLineBreak()
{
  if( m_logFile.is_open() )
  {
    m_logFile << endl;
    m_bIndentWritten = false;
  }
}

void CDebugLogger::WriteIndentChars()
{
  if( m_logFile.is_open() )
  {
    if( !m_bIndentWritten )
    {
      if( m_nIndent > 0 )
      {
        for( int i = 0; i < m_nIndent; i++ )
          m_logFile << IndentChar;
      }
      m_bIndentWritten = true;
    }
  }
}

void CDebugLogger::IncrementIndent()
{
  m_nIndent++;
}

void CDebugLogger::DecrementIndent()
{
  m_nIndent--;
}

#pragma endregion